/*
 * Decompiled with CFR 0.152.
 */
package control;

import control.Button;
import control.EndControl;
import control.GameControl;
import control.MenuControl;
import control.ScoreControl;
import control.SongChooser;
import data.Constants;
import java.io.IOException;
import main.Game;
import model.PlayerModel;
import org.lwjgl.input.Mouse;
import view.KeyboardInput;

public class MainControl {
    private PlayerModel p = new PlayerModel(Constants.DEFAULT_PLAYER_X, Constants.DEFAULT_PLAYER_Y);
    public static float saturation;
    public static boolean scoreAdded;
    private boolean isPlaying;
    public static MenuControl menuControl;
    GameControl gameControl;
    public static SongChooser songChooser;
    public static ScoreControl scoreControl;
    EndControl end;
    public static boolean songBegin;

    static {
        menuControl = new MenuControl();
        songChooser = new SongChooser();
        scoreControl = new ScoreControl();
    }

    public MainControl(int iMaxNumEnemies) {
        menuControl.initialize();
        scoreControl.initializeFile();
        this.isPlaying = true;
        songBegin = false;
        Mouse.setGrabbed(true);
    }

    public void update() {
        KeyboardInput.update(this.gameControl);
        if (this.isPlaying) {
            if (Constants.currentGameState == 0) {
                if (this.end != null) {
                    this.end = null;
                }
                this.p.setToMaxRadius();
                scoreControl.update();
                songChooser.update();
                menuControl.update();
                this.p.draw(0.01f);
            } else if (Constants.currentGameState == 1) {
                if (songBegin) {
                    menuControl.fadeToBlack();
                    this.p.draw(0.01f);
                }
                if (this.gameControl == null || this.gameControl.getSoundController() == null) {
                    Game.startGame();
                } else {
                    this.gameControl.update();
                }
            } else if (Constants.currentGameState == 3) {
                if (this.end == null) {
                    MenuControl.offsetX = Constants.VIEW_WIDTH * 2 + 200;
                    MenuControl.offsetY = 0.0f;
                    Button.xOffset = Constants.VIEW_WIDTH * 2 + 200;
                    Button.yOffset = 0;
                    this.end = new EndControl(this.gameControl.getColorArrangement(), this.gameControl);
                    this.p.setToMaxRadius();
                    songBegin = false;
                } else {
                    if (!this.end.update()) {
                        EndControl.move = false;
                        this.end = null;
                    }
                    menuControl.update();
                    scoreControl.update();
                }
                this.p.draw(0.01f);
            }
        }
    }

    public void newGame() throws IOException {
        this.gameControl = new GameControl(Constants.MAX_NUM_ENEMIES, this.p);
    }

    public void closeRequested() {
        this.isPlaying = false;
        scoreControl.writeToFile();
        if (Constants.currentGameState == 1) {
            this.gameControl.endGame();
        }
    }
}

